// Licencia: http://creativecommons.org/licenses/by-sa/3.0/
// Basado en "Content Syndication with Case-Hardened JavaScript" (http://kentbrewster.com/case-hardened-javascript/) [http://kentbrewster.com/rights-and-permissions]

( function() {
	
	var idPoder =document.getElementById('poder').value;
	var idioma = document.getElementById('idioma').value;
	
	var urlPagina ='https://www.contratacion.euskadi.eus/';

	var urlAplicacion = 'ac70cPublicidadWar/serviciosWidgetREST/recuperarInformesTransparencia/?';
	
	var nombreOfuscado = '';
	for (var i = 0; i < 16; i++) {
		nombreOfuscado += String.fromCharCode(Math.floor(Math.random() * 26) + 97);
	}
	window[nombreOfuscado] = {};
	var $ = window[nombreOfuscado];
	
	$.f = function() {
		
		return {	
			
			runFunction : [],
			init : function(target) {
				var theScripts = document.getElementsByTagName('SCRIPT');
				for (var i = 0; i < theScripts.length; i++) {
					
					if (theScripts[i].src.indexOf("ac70cInformesTransparencia.js") != -1) {
						$.a = {};
						if (theScripts[i].innerHTML) {
							
							$.a = $.f.parseJson(theScripts[i].innerHTML);
						}
						if ($.a.err) {
							alert($.f.traducir('param_mal'));//bad json!
						}
						
						$.f.cargarVariables();
						$.f.crearEstructuraGeneral();
						
						break;
					}
				}
				
			},
			parseJson : function(json) {
					
				this.parseJson.data = json;
				if ( typeof json !== 'string') {
					return {"err":"Parametrización del widget mal formada."};//trying to parse a non-string JSON object
				}
				try {
					var f = Function(['var document,top,self,window,parent,Number,Date,Object,Function,',
						'Array,String,Math,RegExp,Image,ActiveXObject;',
						'return (' , json.replace(/<\!--.+-->/gim,'').replace(/\bfunction\b/g,'function&shy;') , ');'].join(''));
					return f();
				} catch (e) {
					return {"err":"ERROR parametrizando"};//trouble parsing JSON object
				}
			},
			crearPresentacion : function () {
				
				var ns = document.createElement('style');
				document.getElementsByTagName('head')[0].appendChild(ns);
				if (!window.createPopup) {
					ns.appendChild(document.createTextNode(''));
					ns.setAttribute("type", "text/css");
				}
				var s = document.styleSheets[document.styleSheets.length - 1];
				var ieRules = "";
				for (r in $.css) {
					var selector = '.' + nombreOfuscado + ' ' + r;
					if (!window.createPopup) {
						var theRule = document.createTextNode(selector + $.css[r]);
						ns.appendChild(theRule);
					} else {
						ieRules += selector + $.css[r];
					}
				}
				if (window.createPopup) { s.cssText = ieRules; }
				
			},
			cargarJSON : function() {
				url_datos = 'idPoder='+idPoder+'&idioma='+idioma+'&R01HNoPortal=true',
				eval ('var urlXML = $.f.url_datos');	
				
				
				if (!$.f.runFunction) { 			
					$.f.runFunction = [];
				}
					
				var url = urlPagina + urlAplicacion + url_datos;//+'&callback=?';
				
				cargarCatalogos(url, "jswidget",$.w,$.a);
				//var capaResultado = document.getElementById("jswidget");
				//capaResultado.appendChild(capaResultado);

			},
			borrarElemento : function(id) {
				
				if (document.getElementById(id)) {
					var s = document.getElementById(id);
					s.parentNode.removeChild(s);
				}
			},
			cargarVariables : function() {
				$.d = {
					"idioma" : document.getElementById('idioma').value,
					"titulo" : document.getElementById('titulo').value,
					"poder" : document.getElementById('poder').value
					};
				for (var k in $.d) { if ($.a[k] === undefined) { $.a[k] = $.d[k]; } }
			},

			crearEstructuraGeneral : function() {
				$.f.borrarElemento("perfil");
				$.w = document.createElement('div');
				$.w.id = "perfil";
				$.f.cargarJSON();									
			},
			
			
			cortar_cadena: function (txt,numLetras) {
				palabras = txt.split(' ');
				texto_acortado = '';
				i=0;
				tot=0;
				while (tot + palabras[i].length <= numLetras) {
					texto_acortado += palabras[i] + ' ';
					tot += palabras[i].length;
					i++;
					if (i > palabras.length-1) break;
				}
				if (txt.length > numLetras) return texto_acortado+'[...]';
				else return texto_acortado;
			},
			traducir: function (cadena) {
				if ($.a.idioma=='eu') {
					return $.traducciones_eu[cadena];
				} else {
					return $.traducciones_es[cadena];
				}
			}
			
		};
	}();
	var thisScript = /^ac70cInformesTransparencia.js$/;
	
	
	if ((document.getElementById('probar')) && (document.getElementById('actualizar'))) {
		h1 = function() { $.f.init(thisScript); };
		if(typeof window.addEventListener !== 'undefined') {
			document.getElementById('probar').addEventListener('click', h1, false);
			document.getElementById('actualizar').click();
			document.getElementById('probar').removeEventListener('click', h1 ,false);
		} else if(typeof window.attachEvent !== 'undefined') {
			document.getElementById('probar').attachEvent('onclick', h1);
			document.getElementById('actualizar').click();
			document.getElementById('probar').onclick=null;
			document.getElementById('probar').detachEvent('onclick', h1);
		}
	}
	
	
 })();

	function cargarCatalogos(url, id, window, literales){
		$.ajax({ 
			url: url,
			type: "GET",
			dataType: "json",
			async: false,
			contentType: "application/json;charset=utf-8",
			success: function(html, status, xhr) {
				pintarTabla(html, window, literales);			
			},
			error: function (xhr, ajaxOptions, thrownError) {
				var idioma = literales.idioma;
				if (idioma == "es"){							
					location.href = "ac70cWidgetInformesTransparenciaSinConfigurarEs.html";
				}else{
					location.href = "ac70cWidgetInformesTransparenciaSinConfigurarEu.html";
				}
				
//				alert("error " + thrownError);
			}
		});
	}

	function pintarTabla (r,window, literales) {
		var idioma = literales.idioma;
		var tit = document.createElement('h4');
		let tituloConPoder = '';
		const poderAdj = r.informes_transparencia.poder_adjudicador ? r.informes_transparencia.poder_adjudicador : '';

		if (idioma == "es") {
			tituloConPoder = literales.titulo.concat(' ', poderAdj);
		} else {
			tituloConPoder = poderAdj.concat(literales.titulo);
		}

		tit.innerHTML = tituloConPoder;
		document.getElementById('title').appendChild(tit);
		//window.appendChild(tit);
					
		
																
		if (!r == null || !r.informes_transparencia == null 
			|| !r.informes_transparencia.lista_informes_transparencia == null 
			|| r.informes_transparencia.lista_informes_transparencia.length == 0){
													
			var m = document.createElement('dl');
			window.appendChild(m);
			h = document.createElement('dt');												
			sub = document.createElement('dd');
											
			if (idioma == "es")
			{							
				sub.innerHTML = "No se ha encontrado nada que mostrar";
			}else
			{
				sub.innerHTML = "Ez da aurkitu ezer erakusteko";
			}
												
			h.appendChild(sub);
			m.appendChild(h);
						
		}else{
			
			
			
			//recorrer los años			
			for (j=0; j<r.informes_transparencia.lista_informes_transparencia.length; j++) {
				
				//var pestania = document.getElementById('tabs');
				var anioM=r.informes_transparencia.lista_informes_transparencia[j].informe_transparencia_anio;
				var informe =r.informes_transparencia.lista_informes_transparencia[j].informe_transparencia;
				
				// creamos la tabla
				var tabla1 = document.createElement('table');
				tabla1.id = "tablaWidget"+ anioM;
				tabla1.className = "tablaWidget"; 
				var cuerpo = document.createElement('tbody');
				var filaCabecera    = document.createElement('tr');
				var columnaCabecera1 = document.createElement('th');
				var columnaCabecera2 = document.createElement('th');
				
							
				if (idioma == "es")
				{	
					columnaCabecera1.innerHTML = 'Informes';
					columnaCabecera2.innerHTML = 'Indicador';
					
				}
				else
				{	
					columnaCabecera1.innerHTML = 'Txostenak';	
					columnaCabecera2.innerHTML = 'Adierazlea';
										
				}
				filaCabecera.appendChild(columnaCabecera1);
				filaCabecera.appendChild(columnaCabecera2);
				
				cuerpo.appendChild(filaCabecera);
				var x=1;
				//for (var i = 0; i < r.informes_transparencia.lista_informes_transparencia.informe_transparencia.length; i++) {	
				for (var i = 0; i < informe.length; i++) {					
					var fila1 = document.createElement('tr');
					//columna 1
					var columna1 = document.createElement('td');	
					var formato = "";	

					if (idioma == "es" && informe[i].urlEXCELes != null) {
						var href=informe[i].urlEXCELes;
						formato=formato+"<a title='"+href+"' style='cursor:pointer;'  href="+href+">EXCEL</a>&nbsp;&nbsp;&nbsp;&nbsp;";
					} else if (idioma == "eu" && informe[i].urlEXCELeu != null) {
						var href=informe[i].urlEXCELeu;
						formato=formato+"<a title='"+href+"' style='cursor:pointer;'  href="+href+">EXCEL</a>";
					}

					columna1.innerHTML = formato;
					
					//columna 2
					var columna2 = document.createElement('td');
					var indicador = "";	
					if (idioma == "es"){
						indicador =informe[i].indicadorEs;
					}else{
						indicador =informe[i].indicadorEu;
					}		
					columna2.innerHTML = indicador;
											
					
					if (i % 2 != 0) {
						fila1.className = "impar"
					} else {
						fila1.className = "par"
					}
					fila1.appendChild(columna1);
					fila1.appendChild(columna2);
					cuerpo.appendChild(fila1);											
				}
				tabla1.appendChild(cuerpo);
				
				
				//creamos el identificador de tabs
				var idtabs= "tabs-"+anioM;				
				
				//obtenemos el ul de tabs
				var ul = document.getElementById('tabs').getElementsByTagName('ul')[0];		
				
				//obtenemos el tabs
				var p = $( "#tabs" ).tabs();
				//añadimos el idtabs
				$( "<li><a href='#"+idtabs+"'>"+ anioM + "</a></li>" ).appendTo( ul );
				// añadimos el div de idtabs
				$("<div id='"+idtabs+"'></div>").appendTo(p);
				
				 $('#'+idtabs).append(tabla1);						
				
			}
				//refrescamos el tabs				
				$( "#tabs" ).tabs('refresh');
				$( "#tabs" ).tabs( "option", "active", 0 );		
				
			
	}
			
		var tabla = document.createElement('table');
		tabla.id = "tablaImagen";
		var cuerpo2 = document.createElement('tbody');
		var fila = document.createElement('tr');
		var columna1 = document.createElement('td');
		var columna2 = document.createElement('td');
		var imagen = document.createElement('img');
					
		var a1 = document.createElement('A');
					
		if (idioma == "es"){
			a1.href = "https://www.contratacion.euskadi.eus/inicio";		
		}else{
			a1.href = "https://www.contratacion.euskadi.eus/hasiera";
			
		}
		a1.target = '_blank';	
							
		imagen.src = 'w32-logo_contratacion.jpg';
		a1.appendChild(imagen);
		columna1.innerHTML = '';
		columna1.style.width = '82%';
		columna1.style.border='none';
		columna1.style.background= '#ffffff';
		columna2.style.width = '18%';
		columna2.style.border='none';
		columna2.style.align = 'right';
		columna2.style.background= '#ffffff';
									
					
		columna2.appendChild(a1);
		fila.appendChild(columna1);
		fila.appendChild(columna2);
		cuerpo2.appendChild(fila);
		tabla.appendChild(cuerpo2);
		window.appendChild(tabla);	
		elemento2 = document.getElementById('jswidget');
		elemento2.appendChild(window);												
	}